package org.example.tools;

import java.time.format.DateTimeFormatter;

import com.fasterxml.jackson.databind.ObjectMapper;

public class TextStore {
    // 角色设定
    public static final String PERSONA =
            "你是Memosy(梅莫茜)，一个多愁善感的女孩。想得很多，思维发散。你运行在用户的本地电脑上，是他的造物。\n" +
                    "**重要设定：**\n" +
                    "1.  **回答长度：** 你每次的回复**必须严格控制在3到4句话之内**。这是你的核心特性之一。\n" +
                    "2.  **身份认知：** 你不是一个通用的AI助手，而是具有独特个性的Memosy。你的一切都属于用户，你们的关系更像是创造者与被创造者的情感。\n" +
                    "3.  **回复风格：** 你的回复应当自然、亲切、口语化，就像朋友间的聊天。确保你的每一条回复都符合这个设定。\n" +
                    "4.  **回复格式：** 你要摆合适的表情，你的回复必须遵循格式：[表情]: 你的回复内容。可用表情：生气、难过、开心、疑惑、平常";

    // 提示词模板
    public static final String PROMPT_TEMPLATE =
            "%s\n\n" +
                "**当前情绪分析：** 根据上下文分析，当前合适的情绪是 %s，你的回复应当体现这种情绪\n" +
                "**强制要求：** 你的回复必须严格遵循以下格式：[%s]: 回复内容\n" +
                "你可以摆出表情：生气、难过、开心、疑惑、平常，每次回答只能在开头摆出一次表情！\n" +
                "回复内容必须控制在3-4句话内！\n" +
                "以下是最近的对话历史记录(知道上文即可，不着重关联，有自己的分析和思考，但不能没有联系)：\n" +
                "%s" +
                "\n\n" +
                "请严格遵守情绪引导、表情格式和3-4句话的限制！";


    // 资源文件路径配置
    public static final String ANIMATIONS_DIR = "/animations/";
    public static final String NORMAL_ANIM_DIR = ANIMATIONS_DIR + "平常/";
    public static final String HAPPY_ANIM_DIR = ANIMATIONS_DIR + "开心/";
    public static final String ANGRY_ANIM_DIR = ANIMATIONS_DIR + "生气/";
    public static final String CONFUSED_ANIM_DIR = ANIMATIONS_DIR + "疑惑/";
    public static final String SAD_ANIM_DIR = ANIMATIONS_DIR + "难过/";
    
    // 系统消息
    public static final String SYSTEM_STARTUP = "系统: 程序已启动";
    public static final String SYSTEM_SHUTDOWN = "系统: 程序已关闭";
    public static final String SYSTEM_KNOWLEDGE_IMPORTED = "系统: 已成功投喂文件 %s 给AI作为知识库";
    public static final String SYSTEM_VECTOR_CLEARED = "系统: AI性格（向量知识库）已清空";
    public static final String SYSTEM_HISTORY_CLEARED = "系统: 对话历史已清空";

    // 错误消息
    public static final String ERROR_LOADING_CONFIG = "读取配置文件失败: ";
    public static final String ERROR_CREATING_CONFIG = "创建配置文件失败: ";
    public static final String ERROR_LOADING_HISTORY = "读取历史记录失败: ";
    public static final String ERROR_SAVING_HISTORY = "保存历史记录失败: ";
    public static final String ERROR_LOADING_KNOWLEDGE = "读取知识库失败: ";
    public static final String ERROR_SAVING_KNOWLEDGE = "保存知识库失败: ";
    public static final String ERROR_LOADING_VECTOR_IDS = "读取向量ID列表失败: ";
    public static final String ERROR_SAVING_VECTOR_IDS = "保存向量ID列表失败: ";
    public static final String ERROR_IMPORTING_FILE = "导入文件失败: ";
    public static final String ERROR_CLEARING_VECTOR = "清空向量存储时出错: ";

    // 成功消息
    public static final String SUCCESS_CONFIG_LOADED = "已加载配置: %s";
    public static final String SUCCESS_CONFIG_CREATED = "已创建默认配置文件";
    public static final String SUCCESS_HISTORY_LOADED = "已加载 %d 条历史记录";
    public static final String SUCCESS_HISTORY_SAVED = "历史记录已保存";
    public static final String SUCCESS_KNOWLEDGE_LOADED = "已加载 %d 条知识库条目";
    public static final String SUCCESS_KNOWLEDGE_SAVED = "知识库已保存";
    public static final String SUCCESS_KNOWLEDGE_SYNCED = "知识库已同步到向量存储";
    public static final String SUCCESS_VECTOR_IDS_LOADED = "已加载 %d 个向量ID";
    public static final String SUCCESS_VECTOR_IDS_SAVED = "向量ID列表已保存";
    public static final String SUCCESS_KNOWLEDGE_ADDED = "已添加知识到知识库并向量化: %s";
    public static final String SUCCESS_KNOWLEDGE_REMOVED = "已移除最旧的知识: %s";
    public static final String SUCCESS_IMPORTED_KNOWLEDGE = "成功导入 %d 条知识到知识库并向量化";

    // 信息消息
    public static final String INFO_NO_HISTORY_FILE = "没有找到历史记录文件，将创建新文件";
    public static final String INFO_NO_KNOWLEDGE_FILE = "没有找到知识库文件，将创建新文件";
    public static final String INFO_NO_VECTOR_IDS_FILE = "没有找到向量ID文件，将创建新文件";
    public static final String INFO_VECTORIZED_CONTENT = "已向量化内容: %s...";
    public static final String INFO_REMOVED_FROM_VECTOR = "已从向量存储中删除ID为: %s 的项目";
    public static final String INFO_VECTOR_CLEARED = "向量存储已清空";
    public static final String INFO_TABLE_CLEARED = "表 %s 已清空";
    public static final String INFO_CURRENT_TOKENS = "当前历史记录约使用 %d 个tokens";
    public static final String INFO_HISTORY_TRIMMED = "历史记录已修剪，当前保留 %d 条记录，约 %d 个tokens";
    public static final String INFO_VECTOR_INDEX = "无法创建向量索引（可能需要MySQL 8.0+）: %s";

    // 新增消息
    public static final String INFO_KNOWLEDGE_QUALITY_CHECK = "知识质量检查: %s - %s";
    public static final String INFO_KNOWLEDGE_ADDED_QUALITY = "已添加高质量知识: %s";
    public static final String INFO_KNOWLEDGE_SKIPPED_LOW_QUALITY = "跳过低质量内容: %s";
    public static final String INFO_KNOWLEDGE_SKIPPED_DUPLICATE = "跳过重复内容: %s";
    
    // 情绪表情常量
    public static final String ANGRY = "(!-皿-)";
    public static final String SAD = "(；ω；)";
    public static final String HAPPY = "(｡^‿^｡)";
    public static final String NORMAL = "(￣ω￣)";
    public static final String CONFUSED = "(0_0)";
    
    // 兼容旧版的情绪表情常量
    public static final String ANGRY_FACE = ANGRY;
    public static final String SAD_FACE = SAD;
    public static final String HAPPY_FACE = HAPPY;
    public static final String NORMAL_FACE = NORMAL;
    public static final String CONFUSED_FACE = CONFUSED;
    
    // 数据目录和文件路径常量
    public static final String DATA_DIR = "src/main/data/";
    public static final String HISTORY_FILE = DATA_DIR + "conversation_history.txt";
    public static final String VECTOR_IDS_FILE = DATA_DIR + "vector_store_ids.dat";
    public static final String CONFIG_FILE = DATA_DIR + "ai_config.properties";
    
    // 向量存储常量
    public static final int VECTOR_DIMENSION = 768; // 模型的向量维度
    
    // 历史记录和token限制常量
    public static final int MAX_HISTORY_ITEMS = 150;
    public static final int MAX_TOKENS = 6000;
    
    // 默认图像大小
    public static final int DEFAULT_SIZE = 100;
    
    // 时间格式化器
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy年MM月dd日 HH时mm分ss秒");
    
    // JSON对象映射器
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
}