package org.example.animation;

import org.example.ai.Behave;
import org.example.tools.TextStore;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;

/**
 * 精灵表动画演示程序
 * 用于测试SpriteSheetLoader的功能
 */
public class SpriteSheetDemo extends JFrame {
    private JPanel animationPanel;
    private JLabel fpsLabel;
    private JComboBox<String> emotionComboBox;
    private JSlider fpsSlider;
    private Behave behave;
    private SpriteSheetLoader spriteSheetLoader;

    public SpriteSheetDemo() {
        super("精灵表动画演示");
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setSize(800, 600);
        setLayout(new BorderLayout());

        // 初始化Behave实例
        behave = Behave.getInstance();
        spriteSheetLoader = new SpriteSheetLoader();

        // 创建动画显示面板
        animationPanel = new JPanel() {
            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                // 这里是一个简化的绘制方法，实际应该调用Behave的绘制方法
                if (behave != null) {
                    behave.paintCurrentFrame(g, getWidth() / 2, getHeight() / 2);
                }
            }
        };
        animationPanel.setBackground(Color.WHITE);

        // 设置animationPanel为Behave的绘制面板
        behave.setAnimationPanel(animationPanel);

        // 创建控制面板
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new FlowLayout());

        // 情绪选择下拉框
        emotionComboBox = new JComboBox<>(new String[]{"平常", "开心", "生气", "疑惑", "难过"});
        controlPanel.add(new JLabel("选择情绪: "));
        controlPanel.add(emotionComboBox);

        // 播放按钮
        JButton playButton = new JButton("播放");
        playButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedEmotion = (String) emotionComboBox.getSelectedItem();
                if (selectedEmotion != null) {
                    behave.playEmotion(selectedEmotion);
                    animationPanel.repaint();
                }
            }
        });
        controlPanel.add(playButton);

        // 帧率调整滑块
        fpsLabel = new JLabel("帧率: 30");
        fpsSlider = new JSlider(1, 60, 30);
        fpsSlider.addChangeListener(e -> {
            int fps = fpsSlider.getValue();
            fpsLabel.setText("帧率: " + fps);
            behave.setFrameRate(fps);
        });
        controlPanel.add(fpsLabel);
        controlPanel.add(fpsSlider);

        // 添加组件到主窗口
        add(animationPanel, BorderLayout.CENTER);
        add(controlPanel, BorderLayout.SOUTH);

        // 加载所有情绪的精灵表动画
        loadAllAnimations();
    }

    /**
     * 加载所有情绪的精灵表动画
     */
    private void loadAllAnimations() {
        try {
            // 使用SpriteSheetLoader加载所有情绪的精灵表动画
            SpriteSheetLoader.loadAllEmotionsForBehave(behave);
            System.out.println("所有情绪的精灵表动画加载完成");
        } catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, 
                    "加载精灵表动画时出错: " + e.getMessage(), 
                    "错误", JOptionPane.ERROR_MESSAGE);
        }
    }

    /**
     * 启动演示程序
     */
    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            SpriteSheetDemo demo = new SpriteSheetDemo();
            demo.setVisible(true);
        });
    }
}