#include "widget.h"
#include "./ui_widget.h"
#include "Operate.h"
#include <stack>
#include <QDebug>
#include <cstring>

// 初始化各按钮容错
bool Isllegal[20] = {true};
char btntext[] = {'0','1','2','3','4','5','6','7','8','9','.','+','-','*','/','(',')','='};

Widget::Widget(QWidget *parent)
    : QWidget(parent)
    , ui(new Ui::Widget)
{
    ui->setupUi(this);
    ui->LCD->setEnabled(false);

    //初始化按钮列表
    allButtons =
        {
            ui->push0Button, ui->push1Button, ui->push2Button, ui->push3Button,
            ui->push4Button, ui->push5Button, ui->push6Button, ui->push7Button,
            ui->push8Button, ui->push9Button, ui->pushDotButton, ui->pushJiaButton,
            ui->pushJianButton, ui->pushChengButton, ui->pushChuButton,
            ui->pushLeftButton, ui->pushRightButton, ui->EqualButton
        };

    //初始化表达式
    expression = "";

    updateButtonsState();
}

//检查容错和更新按钮状态用的函数
void Widget::updateButtonsState()
{
    for (int i = 0; i < 18; i++)
    {
        Isllegal[i] = true;
    }

    //处理空表达式
    if (expression.isEmpty())
    {
        //设置哪些可以输入哪些不可以
        for (int i = 0; i <= 10; i++)
        {
            Isllegal[i] = true;
        }
        Isllegal[15] = true; // 左括号
        Isllegal[12] = true; // 减号

        Isllegal[11] = false; // 加号
        Isllegal[13] = false; // 乘号
        Isllegal[14] = false; // 除号
        Isllegal[16] = false; // 右括号
        Isllegal[17] = false; // 等号

        updateButtonEnabledStates();
        return;
    }

    /*----------首先进行最后字符的合法检测----------*/
    //取用户输入的最后一个字符
    QChar lastChar = expression.back();

    //数字和小数点后面不能直接连左括号
    if (lastChar.isDigit() || lastChar == '.')
    {
        Isllegal[15] = false;
    }

    //运算符不能连起来
    if (lastChar == '+' || lastChar == '-' || lastChar == '*' || lastChar == '/')
    {
        for (int i = 11; i <= 14; i++)
        {
            Isllegal[i] = false;
        }
    }

    //左括号不能直接连运算符
    if (lastChar == '(')
    {
        for (int i = 11; i <= 14; i++)
        {
            Isllegal[i] = false;
        }
        Isllegal[12] = true; //减号还是可以作为负号输入的
    }

    //右括号后不能直接连数字或左括号或小数点
    if (lastChar == ')')
    {
        for (int i = 0; i <= 10; i++)
        {
            Isllegal[i] = false;
        }
        Isllegal[15] = false;
    }

    /*----------然后进行数量匹配----------*/
    //括号数量要匹配
    int leftBrackets = 0;
    int rightBrackets = 0;

    for (int i = 0; i < expression.length(); i++)
    {
        if (expression[i] == '(')
        {
            leftBrackets++;
        }
        else if (expression[i] == ')')
        {
            rightBrackets++;
        }
    }

    if (leftBrackets <= rightBrackets)
    {
        Isllegal[16] = false;
    }

    if (leftBrackets != rightBrackets)
    {
        Isllegal[17] = false; //禁用等号按钮
    }

    //小数点数量检查，一个操作数只能有一个小数点
    bool hasDecimal = false;
    for (int i = expression.length() - 1; i >= 0; i--)
    {
        if (expression[i] == '.')
        {
            hasDecimal = true;
            break;
        }
        if (!expression[i].isDigit() && expression[i] != '.')
        {
            break;
        }
    }
    if (hasDecimal) {
        Isllegal[10] = false;
    }

    /*----------最后除号后面可能出现0的情况----------*/
    QList<int> divPositions;

    //寻找除号的位置
    for (int i = 0; i < expression.length(); i++)
    {
        if (expression[i] == '/')
        {
            divPositions.append(i);
        }
    }

    if (!divPositions.isEmpty())
    {
        for (int divPos : divPositions)
        {
            //获取除号后面的表达式
            QString afterDivision;
            int bracketCount = 0;
            bool inNumber = false;

            for (int i = divPos + 1; i < expression.length(); i++)
            {
                QChar c = expression[i];

                if (c == '(')
                {
                    bracketCount++;
                    afterDivision.append(c);
                }
                else if (c == ')')
                {
                    if (bracketCount > 0)
                    {
                        bracketCount--;
                        afterDivision.append(c);
                    }
                    else
                    {
                        break;
                    }
                }
                else if (c.isDigit() || c == '.')
                {
                    afterDivision.append(c);
                }
                else if (c == '+' || c == '-' || c == '*' || c == '/')
                {
                    if (bracketCount == 0)
                    {
                        break;
                    }
                    else
                    {
                        afterDivision.append(c);
                    }
                }
                else
                {
                    afterDivision.append(c);
                }
            }

            if (bracketCount != 0)
            {
                //括号不匹配说明除号后面的表达式不完整，先跳过检查
                continue;
            }

            if (afterDivision.isEmpty())
            {
                continue;
            }

            //计算表达式的结果
            try {
                double value = calculateExpression(afterDivision);
                //如果结果为0那就禁用等于号
                if (std::abs(value) == 0)
                {
                    Isllegal[17] = false;
                    break;
                }

            } catch (const std::exception& e){} //捕捉一下异常让程序不要停止运行
        }
    }

    //更新按钮状态
    updateButtonEnabledStates();
}

void Widget::updateButtonEnabledStates()
{
    for (int i = 0; i < allButtons.size(); i++)
    {
        if (i < 18)
        {
            allButtons[i]->setEnabled(Isllegal[i]);
            if (Isllegal[i] == false) allButtons[i]->setStyleSheet("background:red");
            else allButtons[i]->setStyleSheet("");
        }
    }
}

//计算表达式
double Widget::calculateExpression(QString& str)
{
    if (expression.isEmpty())
    {
        return 0.0;
    }

    //用本地栈避免弄乱全局的
    std::stack<double> OPND;
    std::stack<char> OPTR;
    OPTR.push('#');

    str += '#';

    int index = 0;
    char c = str[index++].toLatin1();

    while (c != '#' || OPTR.top() != '#')
    {
        if (isdigit(c) || c == '.')
        {
            //处理数字
            QString nums;
            while (isdigit(c) || c == '.')
            {
                nums.append(c);
                c = str[index++].toLatin1();
            }

            QByteArray ba = nums.toLocal8Bit();
            char* numChars = ba.data();
            double num = Operate<double>::HandleNumber(numChars);
            OPND.push(num);

        }
        else if (c == '-')
        {
            //判断减号是负号还是运算符
            bool isNegative = false;

            //检查前一个字符
            if (index - 2 >= 0)
            {
                QChar prevChar = str[index - 2];
                //如果是左括号，那减号就是负号，作为操作数使用
                if (prevChar == '(')
                {
                    isNegative = true;
                }
            }
            else
            {
                //空表达式开头也算操作数
                isNegative = true;
            }

            if (isNegative)
            {
                //处理负号：读取完整的负数
                QString nums = "-";
                c = str[index++].toLatin1();

                //读取数字部分
                while (isdigit(c) || c == '.')
                {
                    nums.append(c);
                    c = str[index++].toLatin1();
                }

                QByteArray ba = nums.toLocal8Bit();
                char* numChars = ba.data();
                double num = Operate<double>::HandleNumber(numChars);
                OPND.push(num);
            }
            else
            {
                //运算符处理
                char precedence = Operate<double>::precede(OPTR.top(), c);

                switch (precedence)
                {
                case '<':
                    OPTR.push(c);
                    c = str[index++].toLatin1();
                    break;
                case '=':
                    OPTR.pop();
                    c = str[index++].toLatin1();
                    break;
                case '>':
                    char theta = OPTR.top();
                    OPTR.pop();

                    if (OPND.size() < 2)
                    {
                        throw std::runtime_error("操作数不足");
                    }

                    double b = OPND.top();
                    OPND.pop();
                    double a = OPND.top();
                    OPND.pop();
                    double result = Operate<double>::Calculate(a, theta, b);
                    OPND.push(result);

                    break;
                }
            }
        }
        else
        {
            //获取优先级
            char precedence = Operate<double>::precede(OPTR.top(), c);

            switch (precedence)
            {
            case '<':
                OPTR.push(c);
                c = str[index++].toLatin1();
                break;
            case '=':
                OPTR.pop();
                c = str[index++].toLatin1();
                break;
            case '>':
                char theta = OPTR.top();
                OPTR.pop();

                if (OPND.size() < 2)
                {
                    throw std::runtime_error("操作数不足");
                }

                double b = OPND.top();
                OPND.pop();
                double a = OPND.top();
                OPND.pop();
                double result = Operate<double>::Calculate(a, theta, b);
                OPND.push(result);

                break;
            }
        }
    }

    double result = OPND.top();

    return result;
}

Widget::~Widget()
{
    delete ui;
}

void Widget::on_pushDotButton_clicked()
{
    expression += ".";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push0Button_clicked()
{
    expression += "0";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push1Button_clicked()
{
    expression += "1";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push2Button_clicked()
{
    expression += "2";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push3Button_clicked()
{
    expression += "3";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push4Button_clicked()
{
    expression += "4";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push5Button_clicked()
{
    expression += "5";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push6Button_clicked()
{
    expression += "6";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push7Button_clicked()
{
    expression += "7";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push8Button_clicked()
{
    expression += "8";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_push9Button_clicked()
{
    expression += "9";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_pushLeftButton_clicked()
{
    expression += "(";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_pushRightButton_clicked()
{
    expression += ")";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_pushJiaButton_clicked()
{
    expression += "+";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_pushJianButton_clicked()
{

    //运算符，那就把数字压入操作数栈
    expression += "-";
    ui->LCD->setText(expression);

    updateButtonsState();
}

void Widget::on_pushChengButton_clicked()
{
    expression += "*";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_pushChuButton_clicked()
{
    expression += "/";
    ui->LCD->setText(expression);
    updateButtonsState();
}

void Widget::on_ClearButton_clicked()
{
    expression.clear();
    ui->LCD->setText(expression);

    updateButtonsState();
}

void Widget::on_DeleteButton_clicked()
{
    if (!expression.isEmpty())
    {
        expression.chop(1);
        ui->LCD->setText(expression);
        updateButtonsState();
    }
}

void Widget::on_EqualButton_clicked()
{
    try
    {
        double result = calculateExpression(expression);

        //将结果作为操作数然后显示
        expression = QString::number(result);
        ui->LCD->setText(expression);


        updateButtonsState();

    }
    catch (const std::exception& e)
    {
        //真的出现错误那真没招了，启用清屏按钮重置所有状态吧
        on_ClearButton_clicked();
    }
}
