#ifndef OPERATE_H
#define OPERATE_H

#include <QString>
#include <stack>
#include <stdexcept>
#include <cctype>

template <typename T>
class Operate
{
public:
    Operate() {}

    static void Init(std::stack<T>& stackParam, int type);
    static T Calculate(T a, char theta, T b);
    static char precede(char TopOfOPTR, char c);
    static T HandleNumber(char Nums[]);
};

template <typename T>
void Operate<T>::Init(std::stack<T>& stackParam, int type)
{
    switch (type) {
    case 1: // 运算符栈
        while (!stackParam.empty()) {
            stackParam.pop();
        }
        stackParam.push('#');
        break;
    case 2: // 操作数栈
        while (!stackParam.empty()) {
            stackParam.pop();
        }
        break;
    default:
        break;
    }
}

template <typename T>
T Operate<T>::Calculate(T a, char theta, T b)
{
    switch (theta) {
    case '+':
        return a + b;
    case '-':
        return a - b;
    case '*':
        return a * b;
    case '/':
        if (b == 0) {
            throw std::runtime_error("Division by zero");
        }
        return a / b;
    default:
        throw std::invalid_argument("Invalid operator");
    }
}

template <typename T>
char Operate<T>::precede(char TopOfOPTR, char c)
{
    // 定义有效的运算符
    const std::string validOperators = "+-*/()#";

    // 如果任一字符不是有效运算符，返回's'表示跳过处理
    if (validOperators.find(TopOfOPTR) == std::string::npos ||
        validOperators.find(c) == std::string::npos) {
        return 's'; // 's'表示skip，跳过处理
    }

    int b1, b2;

    switch (TopOfOPTR) {
    case '+': b1 = 0; break;
    case '-': b1 = 1; break;
    case '*': b1 = 2; break;
    case '/': b1 = 3; break;
    case '(': b1 = 4; break;
    case ')': b1 = 5; break;
    case '#': b1 = 6; break;
    default:  return 's';
    }

    switch (c) {
    case '+': b2 = 0; break;
    case '-': b2 = 1; break;
    case '*': b2 = 2; break;
    case '/': b2 = 3; break;
    case '(': b2 = 4; break;
    case ')': b2 = 5; break;
    case '#': b2 = 6; break;
    default:  return 's';
    }

    char table[7][7] = {
        { '>', '>', '<', '<', '<', '>', '>' },
        { '>', '>', '<', '<', '<', '>', '>' },
        { '>', '>', '>', '>', '<', '>', '>' },
        { '>', '>', '>', '>', '<', '>', '>' },
        { '<', '<', '<', '<', '<', '=', 'i' },
        { '>', '>', '>', '>', 'i', '>', '>' },
        { '<', '<', '<', '<', '<', 'i', '=' }
    };

    return table[b1][b2];
}

template <typename T>
T Operate<T>::HandleNumber(char Nums[])
{
    // 检查空数组
    if (Nums[0] == '\0') {
        return static_cast<T>(0);
    }

    double result = 0.0;
    double fraction = 0.0;
    double divisor = 1.0;
    bool decimalPointFound = false;
    bool hasDigit = false;
    bool isNegative = false;
    int startIndex = 0;

    // 检查是否为负数
    if (Nums[0] == '-') {
        isNegative = true;
        startIndex = 1;
    }

    for (int i = startIndex; Nums[i] != '\0'; i++) {
        if (Nums[i] == '.') {
            if (decimalPointFound) {
                throw std::runtime_error("Multiple decimal points");
            }
            decimalPointFound = true;
            continue;
        }

        if (std::isdigit(Nums[i]))
        {
            hasDigit = true;
            int digit = Nums[i] - '0';

            if (decimalPointFound)
            {
                fraction = fraction * 10 + digit;
                divisor *= 10;
            }
            else
            {
                result = result * 10 + digit;
            }
        }
        else
        {
            throw std::runtime_error("Invalid character in number");
        }
    }

    // 如果没有有效数字，返回0
    if (!hasDigit) {
        return static_cast<T>(0);
    }

    result += fraction / divisor;

    // 应用负号
    if (isNegative) {
        result = -result;
    }

    return static_cast<T>(result);
}

#endif // OPERATE_H
